REBOL [
	subject: "Interfaage avec mysql via JDBC"
	version: 1.0
	author: "Olivier Auverlot"
]

make root-protocol [
	scheme: 'jdbc
	port-id: 8000
	port-flags: system/standard/port-flags/pass-thru
	open-check: none
	buffer: make block! []

	open: func [ port ] [
		open-proto port
		port/state/index: 0
		port/state/tail: 65535
	]

	insert: function [ port data ] [ url ] [ 
		url: System/words/copy join "jdbc:mysql://" [ port/path port/target ]
		system/words/insert port/sub-port join url [
			"|" port/user "|" port/pass "|" data "|^/"
		]
	]	

	copy: func [ port ] [
		; dcoupe des informations lues
		buffer: system/words/copy parse to-string (system/words/copy port/sub-port) "|"
		; on initialise la taille max de la srie
		port/state/tail: length? buffer
		buffer
	]

	pick: func [ port ] [
		; selon la position du pointeur, on retourne une valeur
		system/words/pick buffer port/state/index
	]
	
	net-utils/net-install jdbc self 8000
]
